package ru.yandex.intranet.d.loaders;

import java.util.Objects;

import ru.yandex.intranet.d.model.TenantId;

/**
 * Cache key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CacheKey<T> {

    private final T id;
    private final TenantId tenantId;

    public CacheKey(T id, TenantId tenantId) {
        this.id = id;
        this.tenantId = tenantId;
    }

    public T getId() {
        return id;
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CacheKey<?> cacheKey = (CacheKey<?>) o;
        return Objects.equals(id, cacheKey.id) &&
                Objects.equals(tenantId, cacheKey.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tenantId);
    }

    @Override
    public String toString() {
        return "CacheKey{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                '}';
    }

}
