package ru.yandex.intranet.d.loaders.units;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

import ru.yandex.intranet.d.dao.units.UnitsEnsemblesDao;
import ru.yandex.intranet.d.datasource.model.YdbTableClient;
import ru.yandex.intranet.d.datasource.model.YdbTxSession;
import ru.yandex.intranet.d.loaders.ByIdLoader;
import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

/**
 * Units ensembles loader.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class UnitsEnsemblesLoader {

    private final ByIdLoader<String, UnitsEnsembleModel> byIdLoader;

    public UnitsEnsemblesLoader(UnitsEnsemblesDao unitsEnsemblesDao, YdbTableClient ydbTableClient) {
        this.byIdLoader = new ByIdLoader<>(1000, 1000,
                Duration.of(30, ChronoUnit.MINUTES), Duration.of(30, ChronoUnit.MINUTES),
                ydbTableClient, "units ensembles", 300,
                unitsEnsemblesDao::getByIds,
                (ts, id) -> unitsEnsemblesDao.getById(ts, id.getT1(), id.getT2()),
                UnitsEnsembleModel::getId, UnitsEnsembleModel::getTenantId);
    }

    public Mono<Optional<UnitsEnsembleModel>> getUnitsEnsembleById(YdbTxSession session, String id,
                                                                   TenantId tenantId) {
        return byIdLoader.getById(session, id, tenantId);
    }

    public Mono<List<UnitsEnsembleModel>> getUnitsEnsemblesByIds(YdbTxSession session,
                                                                 List<Tuple2<String, TenantId>> ids) {
        return byIdLoader.getByIds(session, ids);
    }

    public Mono<Optional<UnitsEnsembleModel>> getUnitsEnsembleByIdImmediate(String id, TenantId tenantId) {
        return byIdLoader.getByIdImmediate(id, tenantId);
    }

    public Mono<List<UnitsEnsembleModel>> getUnitsEnsemblesByIdsImmediate(List<Tuple2<String, TenantId>> ids) {
        return byIdLoader.getByIdsImmediate(ids);
    }

    public void update(UnitsEnsembleModel unitsEnsemble) {
        byIdLoader.update(unitsEnsemble);
    }

    @Scheduled(fixedDelayString = "${caches.unitsEnsemblesCacheRefreshDelayMs}",
            initialDelayString = "${caches.unitsEnsemblesCacheRefreshInitialDelayMs}")
    public void refreshCache() {
        byIdLoader.refresh();
    }

}
