package ru.yandex.intranet.d.metrics;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Readiness metrics.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@Component
public class ProbeMetrics {
    private static final String TVM_PING_ERROR = "readiness.tvm.ping.error";
    private static final String YDB_PING_ERROR = "readiness.ydb.ping.error";
    private static final String LIVENESS_OK_RATE = "liveness.ok.rate";
    private final GaugeInt64 tvmPingErrors;
    private final GaugeInt64 ydbPingErrors;
    private final Rate livenessOkCount;

    public ProbeMetrics() {
        this.tvmPingErrors = MetricRegistry.root().gaugeInt64(TVM_PING_ERROR);
        this.ydbPingErrors = MetricRegistry.root().gaugeInt64(YDB_PING_ERROR);
        this.livenessOkCount = MetricRegistry.root().rate(LIVENESS_OK_RATE);
    }

    public void onLivenessProbe() {
        livenessOkCount.inc();
    }

    public void onReadinessProbe(boolean isTvmError, boolean isYdbError) {
        tvmPingErrors.set(isTvmError ? 1L : 0L);
        ydbPingErrors.set(isYdbError ? 1L : 0L);
    }

    public void onReadinessProbeIsTvmError() {
        tvmPingErrors.set(1L);
    }

    public void onReadinessProbeIsYdbError() {
        ydbPingErrors.set(1L);
    }
}
