package ru.yandex.intranet.d.metrics;

import java.time.Duration;
import java.time.Instant;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Transfer request refresh metrics.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
@Component
public class TransferRequestRefreshMetrics {
    private static final String REFRESH_TRANSFER_REQUESTS_SUCCESSFUL =
            "transfer_request.refresh.successful";
    private static final String REFRESH_TRANSFER_REQUESTS_FAILED =
            "transfer_request.refresh.failed";
    private static final String REFRESH_TRANSFER_REQUESTS_TIME_SINCE_NO_FAILED =
            "transfer_request.refresh.time_since_no_failed";
    private static final String REFRESH_TRANSFER_REQUESTS_TIME_SINCE_NOT_ALL_FAILED =
            "transfer_request.refresh.time_since_not_all_failed";
    private final GaugeInt64 successfulMetric =
            MetricRegistry.root().gaugeInt64(REFRESH_TRANSFER_REQUESTS_SUCCESSFUL);
    private final GaugeInt64 failedMetric =
            MetricRegistry.root().gaugeInt64(REFRESH_TRANSFER_REQUESTS_FAILED);
    private Instant lastNoFailedRefresh = Instant.now();
    private Instant lastNotAllFailedRefresh = Instant.now();

    public TransferRequestRefreshMetrics() {
        MetricRegistry.root().lazyGaugeInt64(REFRESH_TRANSFER_REQUESTS_TIME_SINCE_NO_FAILED,
                () -> Duration.between(lastNoFailedRefresh, Instant.now()).toMillis()
        );
        MetricRegistry.root().lazyGaugeInt64(REFRESH_TRANSFER_REQUESTS_TIME_SINCE_NOT_ALL_FAILED,
                () -> Duration.between(lastNotAllFailedRefresh, Instant.now()).toMillis()
        );
    }

    public void updateRefreshTransferRequestResultMetrics(long successful, long failed) {
        Instant now = Instant.now();
        if (failed == 0) {
            lastNoFailedRefresh = now;
        }
        if (failed == 0 || successful > 0) {
            lastNotAllFailedRefresh = now;
        }
        successfulMetric.set(successful);
        failedMetric.set(failed);
    }

}
