package ru.yandex.intranet.d.metrics;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * YDB metrics.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class YdbMetrics {

    private static final String RATE = "ydb.ops.rate";
    private static final String DURATION = "ydb.ops.duration_millis";
    private static final String OP = "ydb_op";
    private static final String RESULT = "ydb_result";
    private static final String ANY = "any";
    private static final String FAILURE = "failure";
    private static final String GET_SESSION = "get_session";
    private static final String RELEASE_SESSION = "release_session";
    private static final String MAKE_DIRECTORY = "make_directory";
    private static final String MAKE_DIRECTORIES = "make_directories";
    private static final String REMOVE_DIRECTORY = "remove_directory";
    private static final String DESCRIBE_PATH = "describe_path";
    private static final String LIST_DIRECTORY = "list_directory";
    private static final String CREATE_TABLE = "create_table";
    private static final String DROP_TABLE = "drop_table";
    private static final String ALTER_TABLE = "alter_table";
    private static final String COPY_TABLE = "copy_table";
    private static final String DESCRIBE_TABLE = "describe_table";
    private static final String EXECUTE_DATA_QUERY = "execute_data_query";
    private static final String PREPARE_DATA_QUERY = "prepare_data_query";
    private static final String EXECUTE_SCHEME_QUERY = "execute_scheme_query";
    private static final String EXPLAIN_DATA_QUERY = "explain_data_query";
    private static final String BEGIN_TRANSACTION = "begin_transaction";
    private static final String COMMIT_TRANSACTION = "commit_transaction";
    private static final String ROLLBACK_TRANSACTION = "rollback_transaction";
    private static final String READ_TABLE = "read_table";
    private static final String SESSION_KEEP_ALIVE = "session_keep_alive";
    private static final String CLOSE_SESSION = "close_session";
    private static final String EXECUTE_SCAN_QUERY = "execute_scan_query";
    private static final String REQUEST_RETRY = "request_retry";
    private static final String SESSION_RETRY = "session_retry";
    private static final String TRANSACTION_RETRY = "transaction_retry";
    private static final String TIMEOUT_RETRY = "timeout_retry";

    private final Rate getSessionRate;
    private final Rate releaseSessionRate;
    private final Rate makeDirectoryRate;
    private final Rate makeDirectoriesRate;
    private final Rate removeDirectoryRate;
    private final Rate describePathRate;
    private final Rate listDirectoryRate;
    private final Rate createTableRate;
    private final Rate dropTableRate;
    private final Rate alterTableRate;
    private final Rate copyTableRate;
    private final Rate describeTableRate;
    private final Rate executeDataQueryRate;
    private final Rate prepareDataQueryRate;
    private final Rate executeSchemeQueryRate;
    private final Rate explainDataQueryRate;
    private final Rate beginTransactionRate;
    private final Rate commitTransactionRate;
    private final Rate rollbackTransactionRate;
    private final Rate readTableRate;
    private final Rate sessionKeepAliveRate;
    private final Rate closeSessionRate;
    private final Rate executeScanQueryRate;
    private final Rate getSessionErrorRate;
    private final Rate releaseSessionErrorRate;
    private final Rate makeDirectoryErrorRate;
    private final Rate makeDirectoriesErrorRate;
    private final Rate removeDirectoryErrorRate;
    private final Rate describePathErrorRate;
    private final Rate listDirectoryErrorRate;
    private final Rate createTableErrorRate;
    private final Rate dropTableErrorRate;
    private final Rate alterTableErrorRate;
    private final Rate copyTableErrorRate;
    private final Rate describeTableErrorRate;
    private final Rate executeDataQueryErrorRate;
    private final Rate prepareDataQueryErrorRate;
    private final Rate executeSchemeQueryErrorRate;
    private final Rate explainDataQueryErrorRate;
    private final Rate beginTransactionErrorRate;
    private final Rate commitTransactionErrorRate;
    private final Rate rollbackTransactionErrorRate;
    private final Rate readTableErrorRate;
    private final Rate sessionKeepAliveErrorRate;
    private final Rate closeSessionErrorRate;
    private final Rate executeScanQueryErrorRate;
    private final Rate requestRetryRate;
    private final Rate sessionRetryRate;
    private final Rate transactionRetryRate;
    private final Rate timeoutRetryRate;
    private final Histogram getSessionDuration;
    private final Histogram releaseSessionDuration;
    private final Histogram makeDirectoryDuration;
    private final Histogram makeDirectoriesDuration;
    private final Histogram removeDirectoryDuration;
    private final Histogram describePathDuration;
    private final Histogram listDirectoryDuration;
    private final Histogram createTableDuration;
    private final Histogram dropTableDuration;
    private final Histogram alterTableDuration;
    private final Histogram copyTableDuration;
    private final Histogram describeTableDuration;
    private final Histogram executeDataQueryDuration;
    private final Histogram prepareDataQueryDuration;
    private final Histogram executeSchemeQueryDuration;
    private final Histogram explainDataQueryDuration;
    private final Histogram beginTransactionDuration;
    private final Histogram commitTransactionDuration;
    private final Histogram rollbackTransactionDuration;
    private final Histogram readTableDuration;
    private final Histogram sessionKeepAliveDuration;
    private final Histogram closeSessionDuration;
    private final Histogram executeScanQueryDuration;

    public YdbMetrics() {
        this.requestRetryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, REQUEST_RETRY, RESULT, ANY));
        this.sessionRetryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, SESSION_RETRY, RESULT, ANY));
        this.transactionRetryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, TRANSACTION_RETRY, RESULT, ANY));
        this.timeoutRetryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, TIMEOUT_RETRY, RESULT, ANY));
        this.getSessionRate = MetricRegistry.root().rate(RATE, Labels.of(OP, GET_SESSION, RESULT, ANY));
        this.releaseSessionRate = MetricRegistry.root().rate(RATE, Labels.of(OP, RELEASE_SESSION, RESULT, ANY));
        this.makeDirectoryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, MAKE_DIRECTORY, RESULT, ANY));
        this.makeDirectoriesRate = MetricRegistry.root().rate(RATE, Labels.of(OP, MAKE_DIRECTORIES, RESULT, ANY));
        this.removeDirectoryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, REMOVE_DIRECTORY, RESULT, ANY));
        this.describePathRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DESCRIBE_PATH, RESULT, ANY));
        this.listDirectoryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, LIST_DIRECTORY, RESULT, ANY));
        this.createTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, CREATE_TABLE, RESULT, ANY));
        this.dropTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DROP_TABLE, RESULT, ANY));
        this.alterTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, ALTER_TABLE, RESULT, ANY));
        this.copyTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, COPY_TABLE, RESULT, ANY));
        this.describeTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DESCRIBE_TABLE, RESULT, ANY));
        this.executeDataQueryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_DATA_QUERY, RESULT, ANY));
        this.prepareDataQueryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, PREPARE_DATA_QUERY, RESULT, ANY));
        this.executeSchemeQueryRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_SCHEME_QUERY, RESULT, ANY));
        this.explainDataQueryRate = MetricRegistry.root().rate(RATE, Labels.of(OP, EXPLAIN_DATA_QUERY, RESULT, ANY));
        this.beginTransactionRate = MetricRegistry.root().rate(RATE, Labels.of(OP, BEGIN_TRANSACTION, RESULT, ANY));
        this.commitTransactionRate = MetricRegistry.root().rate(RATE, Labels.of(OP, COMMIT_TRANSACTION, RESULT, ANY));
        this.rollbackTransactionRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, ROLLBACK_TRANSACTION, RESULT, ANY));
        this.readTableRate = MetricRegistry.root().rate(RATE, Labels.of(OP, READ_TABLE, RESULT, ANY));
        this.sessionKeepAliveRate = MetricRegistry.root().rate(RATE, Labels.of(OP, SESSION_KEEP_ALIVE, RESULT, ANY));
        this.closeSessionRate = MetricRegistry.root().rate(RATE, Labels.of(OP, CLOSE_SESSION, RESULT, ANY));
        this.executeScanQueryRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_SCAN_QUERY, RESULT, ANY));
        this.getSessionErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, GET_SESSION, RESULT, FAILURE));
        this.releaseSessionErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, RELEASE_SESSION, RESULT, FAILURE));
        this.makeDirectoryErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, MAKE_DIRECTORY, RESULT, FAILURE));
        this.makeDirectoriesErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, MAKE_DIRECTORIES, RESULT, FAILURE));
        this.removeDirectoryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, REMOVE_DIRECTORY, RESULT, FAILURE));
        this.describePathErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DESCRIBE_PATH, RESULT, FAILURE));
        this.listDirectoryErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, LIST_DIRECTORY, RESULT, FAILURE));
        this.createTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, CREATE_TABLE, RESULT, FAILURE));
        this.dropTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DROP_TABLE, RESULT, FAILURE));
        this.alterTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, ALTER_TABLE, RESULT, FAILURE));
        this.copyTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, COPY_TABLE, RESULT, FAILURE));
        this.describeTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, DESCRIBE_TABLE, RESULT, FAILURE));
        this.executeDataQueryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_DATA_QUERY, RESULT, FAILURE));
        this.prepareDataQueryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, PREPARE_DATA_QUERY, RESULT, FAILURE));
        this.executeSchemeQueryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_SCHEME_QUERY, RESULT, FAILURE));
        this.explainDataQueryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXPLAIN_DATA_QUERY, RESULT, FAILURE));
        this.beginTransactionErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, BEGIN_TRANSACTION, RESULT, FAILURE));
        this.commitTransactionErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, COMMIT_TRANSACTION, RESULT, FAILURE));
        this.rollbackTransactionErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, ROLLBACK_TRANSACTION, RESULT, FAILURE));
        this.readTableErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, READ_TABLE, RESULT, FAILURE));
        this.sessionKeepAliveErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, SESSION_KEEP_ALIVE, RESULT, FAILURE));
        this.closeSessionErrorRate = MetricRegistry.root().rate(RATE, Labels.of(OP, CLOSE_SESSION, RESULT, FAILURE));
        this.executeScanQueryErrorRate
                = MetricRegistry.root().rate(RATE, Labels.of(OP, EXECUTE_SCAN_QUERY, RESULT, FAILURE));
        this.getSessionDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, GET_SESSION),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.releaseSessionDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, RELEASE_SESSION),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.makeDirectoryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, MAKE_DIRECTORY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.makeDirectoriesDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, MAKE_DIRECTORIES),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.removeDirectoryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, REMOVE_DIRECTORY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.describePathDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, DESCRIBE_PATH),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.listDirectoryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, LIST_DIRECTORY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.createTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, CREATE_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.dropTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, DROP_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.alterTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, ALTER_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.copyTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, COPY_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.describeTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, DESCRIBE_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.executeDataQueryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, EXECUTE_DATA_QUERY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.prepareDataQueryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, PREPARE_DATA_QUERY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.executeSchemeQueryDuration = MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, EXECUTE_SCHEME_QUERY), Histograms.exponential(22, 2.0d, 1.0d));
        this.explainDataQueryDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, EXPLAIN_DATA_QUERY),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.beginTransactionDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, BEGIN_TRANSACTION),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.commitTransactionDuration = MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, COMMIT_TRANSACTION), Histograms.exponential(22, 2.0d, 1.0d));
        this.rollbackTransactionDuration = MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, ROLLBACK_TRANSACTION), Histograms.exponential(22, 2.0d, 1.0d));
        this.readTableDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, READ_TABLE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.sessionKeepAliveDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, SESSION_KEEP_ALIVE),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.closeSessionDuration = MetricRegistry.root().histogramRate(DURATION, Labels.of(OP, CLOSE_SESSION),
                Histograms.exponential(22, 2.0d, 1.0d));
        this.executeScanQueryDuration = MetricRegistry.root().histogramRate(DURATION,
                Labels.of(OP, EXECUTE_SCAN_QUERY), Histograms.exponential(22, 2.0d, 1.0d));
    }

    public void afterGetSession(long durationMillis, boolean success) {
        getSessionRate.inc();
        if (!success) {
            getSessionErrorRate.inc();
        }
        getSessionDuration.record(durationMillis);
    }

    public void afterReleaseSession(long durationMillis, boolean success) {
        releaseSessionRate.inc();
        if (!success) {
            releaseSessionErrorRate.inc();
        }
        releaseSessionDuration.record(durationMillis);
    }

    public void afterMakeDirectory(long durationMillis, boolean success) {
        makeDirectoryRate.inc();
        if (!success) {
            makeDirectoryErrorRate.inc();
        }
        makeDirectoryDuration.record(durationMillis);
    }

    public void afterMakeDirectories(long durationMillis, boolean success) {
        makeDirectoriesRate.inc();
        if (!success) {
            makeDirectoriesErrorRate.inc();
        }
        makeDirectoriesDuration.record(durationMillis);
    }

    public void afterRemoveDirectory(long durationMillis, boolean success) {
        removeDirectoryRate.inc();
        if (!success) {
            removeDirectoryErrorRate.inc();
        }
        removeDirectoryDuration.record(durationMillis);
    }

    public void afterDescribePath(long durationMillis, boolean success) {
        describePathRate.inc();
        if (!success) {
            describePathErrorRate.inc();
        }
        describePathDuration.record(durationMillis);
    }

    public void afterListDirectory(long durationMillis, boolean success) {
        listDirectoryRate.inc();
        if (!success) {
            listDirectoryErrorRate.inc();
        }
        listDirectoryDuration.record(durationMillis);
    }

    public void afterCreateTable(long durationMillis, boolean success) {
        createTableRate.inc();
        if (!success) {
            createTableErrorRate.inc();
        }
        createTableDuration.record(durationMillis);
    }

    public void afterDropTable(long durationMillis, boolean success) {
        dropTableRate.inc();
        if (!success) {
            dropTableErrorRate.inc();
        }
        dropTableDuration.record(durationMillis);
    }

    public void afterAlterTable(long durationMillis, boolean success) {
        alterTableRate.inc();
        if (!success) {
            alterTableErrorRate.inc();
        }
        alterTableDuration.record(durationMillis);
    }

    public void afterCopyTable(long durationMillis, boolean success) {
        copyTableRate.inc();
        if (!success) {
            copyTableErrorRate.inc();
        }
        copyTableDuration.record(durationMillis);
    }

    public void afterDescribeTable(long durationMillis, boolean success) {
        describeTableRate.inc();
        if (!success) {
            describeTableErrorRate.inc();
        }
        describeTableDuration.record(durationMillis);
    }

    public void afterExecuteDataQuery(long durationMillis, boolean success) {
        executeDataQueryRate.inc();
        if (!success) {
            executeDataQueryErrorRate.inc();
        }
        executeDataQueryDuration.record(durationMillis);
    }

    public void afterPrepareDataQuery(long durationMillis, boolean success) {
        prepareDataQueryRate.inc();
        if (!success) {
            prepareDataQueryErrorRate.inc();
        }
        prepareDataQueryDuration.record(durationMillis);
    }

    public void afterExecuteSchemeQuery(long durationMillis, boolean success) {
        executeSchemeQueryRate.inc();
        if (!success) {
            executeSchemeQueryErrorRate.inc();
        }
        executeSchemeQueryDuration.record(durationMillis);
    }

    public void afterExplainDataQuery(long durationMillis, boolean success) {
        explainDataQueryRate.inc();
        if (!success) {
            explainDataQueryErrorRate.inc();
        }
        explainDataQueryDuration.record(durationMillis);
    }

    public void afterBeginTransaction(long durationMillis, boolean success) {
        beginTransactionRate.inc();
        if (!success) {
            beginTransactionErrorRate.inc();
        }
        beginTransactionDuration.record(durationMillis);
    }

    public void afterCommitTransaction(long durationMillis, boolean success) {
        commitTransactionRate.inc();
        if (!success) {
            commitTransactionErrorRate.inc();
        }
        commitTransactionDuration.record(durationMillis);
    }

    public void afterRollbackTransaction(long durationMillis, boolean success) {
        rollbackTransactionRate.inc();
        if (!success) {
            rollbackTransactionErrorRate.inc();
        }
        rollbackTransactionDuration.record(durationMillis);
    }

    public void afterReadTable(long durationMillis, boolean success) {
        readTableRate.inc();
        if (!success) {
            readTableErrorRate.inc();
        }
        readTableDuration.record(durationMillis);
    }

    public void afterSessionKeepAlive(long durationMillis, boolean success) {
        sessionKeepAliveRate.inc();
        if (!success) {
            sessionKeepAliveErrorRate.inc();
        }
        sessionKeepAliveDuration.record(durationMillis);
    }

    public void afterCloseSession(long durationMillis, boolean success) {
        closeSessionRate.inc();
        if (!success) {
            closeSessionErrorRate.inc();
        }
        closeSessionDuration.record(durationMillis);
    }

    public void afterExecuteScanQuery(long durationMillis, boolean success) {
        executeScanQueryRate.inc();
        if (!success) {
            executeScanQueryErrorRate.inc();
        }
        executeScanQueryDuration.record(durationMillis);
    }

    public void afterRequestRetry() {
        requestRetryRate.inc();
    }

    public void afterSessionRetry() {
        sessionRetryRate.inc();
    }

    public void afterTransactionRetry() {
        transactionRetryRate.inc();
    }

    public void afterTimeoutRetry() {
        timeoutRetryRate.inc();
    }

}
