package ru.yandex.intranet.d.model;

import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * String Id with tenant.
 *
 * @deprecated todo: replace by {@code WithTenant<String>}
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 */
@Deprecated
public final class StringIdWithTenant {
    private final TenantId tenantId;
    private final String id;

    public StringIdWithTenant(TenantId tenantId, String id) {
        Preconditions.checkNotNull(tenantId);
        Preconditions.checkNotNull(id);
        this.tenantId = tenantId;
        this.id = id;
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StringIdWithTenant that = (StringIdWithTenant) o;
        return tenantId.equals(that.tenantId) &&
                id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, id);
    }

    @Override
    public String toString() {
        return "IdWithTenant{" +
                "tenantId=" + tenantId +
                ", id='" + id + '\'' +
                '}';
    }
}
