package ru.yandex.intranet.d.model;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Tenant id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class TenantId {

    private final String id;

    @JsonCreator
    public TenantId(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public static TenantId getInstance(String id, Map<String, TenantId> tenantIdCache) {
        return tenantIdCache.computeIfAbsent(id, TenantId::new);
    }

    @JsonValue
    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TenantId tenantId = (TenantId) o;
        return Objects.equals(id, tenantId.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "TenantId{" +
                "id='" + id + '\'' +
                '}';
    }

}
