package ru.yandex.intranet.d.model;

import java.util.Objects;

import reactor.util.function.Tuple2;

/**
 * Identity with TenantId.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 20.10.2020
 */
public final class WithTenant<IdentityClass> {
    private final TenantId tenantId;
    private final IdentityClass identity;

    public WithTenant(TenantId tenantId, IdentityClass identity) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.identity = Objects.requireNonNull(identity);
    }

    public static <T> WithTenant<T> from(Tuple2<T, TenantId> tuple) {
        return new WithTenant<>(tuple.getT2(), tuple.getT1());
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public IdentityClass getIdentity() {
        return identity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WithTenant<?> that = (WithTenant<?>) o;
        return tenantId.equals(that.tenantId) &&
                identity.equals(that.identity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, identity);
    }

    @Override
    public String toString() {
        return "WithTenant{" +
                "tenantId=" + tenantId +
                ", identity=" + identity +
                '}';
    }
}
