package ru.yandex.intranet.d.model.accounts;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nullable;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.providers.ProviderUISettings;
import ru.yandex.intranet.d.model.resources.ResourceSegmentSettingsModel;

/**
 * Model for accounts_spaces table.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 09.12.2020
 */
public final class AccountSpaceModel {
    private final TenantId tenantId;
    private final String id;
    private final boolean deleted;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final String providerId;
    private final String outerKeyInProvider;
    private final long version;
    private final Set<ResourceSegmentSettingsModel> segments;
    private final boolean readOnly;
    private final @Nullable ProviderUISettings uiSettings;
    private final boolean syncEnabled;

    private AccountSpaceModel(Builder builder) {
        this.tenantId = builder.tenantId;
        this.id = builder.id;
        this.deleted = builder.deleted;
        this.nameEn = builder.nameEn;
        this.nameRu = builder.nameRu;
        this.descriptionEn = builder.descriptionEn;
        this.descriptionRu = builder.descriptionRu;
        this.providerId = builder.providerId;
        this.outerKeyInProvider = builder.outerKeyInProvider;
        this.version = builder.version;
        this.segments = builder.segments;
        this.readOnly = builder.readOnly;
        this.uiSettings = builder.uiSettings;
        this.syncEnabled = builder.syncEnabled;
    }

    public static Builder newBuilder(AccountSpaceModel model) {
        Builder builder = new Builder();
        builder.tenantId = model.tenantId;
        builder.id = model.id;
        builder.deleted = model.deleted;
        builder.nameEn = model.nameEn;
        builder.nameRu = model.nameRu;
        builder.descriptionEn = model.descriptionEn;
        builder.descriptionRu = model.descriptionRu;
        builder.providerId = model.providerId;
        builder.outerKeyInProvider = model.outerKeyInProvider;
        builder.version = model.version;
        builder.segments = model.segments;
        builder.readOnly = model.readOnly;
        builder.uiSettings = model.uiSettings;
        builder.syncEnabled = model.syncEnabled;
        return builder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public String getId() {
        return id;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public String getNameEn() {
        return nameEn;
    }

    public String getNameRu() {
        return nameRu;
    }

    public String getDescriptionEn() {
        return descriptionEn;
    }

    public String getDescriptionRu() {
        return descriptionRu;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getOuterKeyInProvider() {
        return outerKeyInProvider;
    }

    public long getVersion() {
        return version;
    }

    public Set<ResourceSegmentSettingsModel> getSegments() {
        return segments;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public Optional<ProviderUISettings> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountSpaceModel that = (AccountSpaceModel) o;
        return deleted == that.deleted &&
                version == that.version &&
                readOnly == that.readOnly &&
                syncEnabled == that.syncEnabled &&
                Objects.equals(tenantId, that.tenantId) &&
                Objects.equals(id, that.id) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(outerKeyInProvider, that.outerKeyInProvider) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, id, deleted, nameEn, nameRu, descriptionEn, descriptionRu, providerId,
                outerKeyInProvider, version, segments, readOnly, uiSettings, syncEnabled);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public static class Builder {

        private TenantId tenantId;
        private String id;
        private boolean deleted;
        private String nameEn;
        private String nameRu;
        private String descriptionEn;
        private String descriptionRu;
        private String providerId;
        private String outerKeyInProvider;
        private long version;
        private Set<ResourceSegmentSettingsModel> segments;
        private boolean readOnly = false;
        private @Nullable ProviderUISettings uiSettings;
        private boolean syncEnabled = true;

        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder setNameEn(String nameEn) {
            this.nameEn = nameEn;
            return this;
        }

        public Builder setNameRu(String nameRu) {
            this.nameRu = nameRu;
            return this;
        }

        public Builder setDescriptionEn(String descriptionEn) {
            this.descriptionEn = descriptionEn;
            return this;
        }

        public Builder setDescriptionRu(String descriptionRu) {
            this.descriptionRu = descriptionRu;
            return this;
        }

        public Builder setProviderId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder setOuterKeyInProvider(String outerKeyInProvider) {
            this.outerKeyInProvider = outerKeyInProvider;
            return this;
        }

        public Builder setVersion(long version) {
            this.version = version;
            return this;
        }

        public Builder setSegments(Set<ResourceSegmentSettingsModel> segments) {
            this.segments = segments;
            return this;
        }

        public Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder setUiSettings(@Nullable ProviderUISettings uiSettings) {
            this.uiSettings = uiSettings;
            return this;
        }

        public Builder setSyncEnabled(boolean syncEnabled) {
            this.syncEnabled = syncEnabled;
            return this;
        }

        public AccountSpaceModel build() {
            return new AccountSpaceModel(this);
        }
    }
}
