package ru.yandex.intranet.d.model.accounts;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Operation changes.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class OperationChangesModel {

    private final String accountId;
    private final List<Provision> updatedProvisions;
    private final List<Provision> frozenProvisions;
    private final AccountCreateParams accountCreateParams;
    private final AccountRenameParams accountRenameParams;
    private final String destinationFolderId;
    private final String destinationAccountId;
    private final List<Provision> updatedDestinationProvisions;
    private final List<Provision> frozenDestinationProvisions;
    private final String transferRequestId;
    private final String deliveryId;
    private final AccountPutParams accountPutParams;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public OperationChangesModel(
            String accountId,
            List<Provision> updatedProvisions,
            List<Provision> frozenProvisions,
            AccountCreateParams accountCreateParams,
            AccountRenameParams accountRenameParams,
            String destinationFolderId,
            String destinationAccountId,
            List<Provision> updatedDestinationProvisions,
            List<Provision> frozenDestinationProvisions,
            String transferRequestId,
            String deliveryId,
            AccountPutParams accountPutParams
    ) {
        this.accountId = accountId;
        this.updatedProvisions = updatedProvisions;
        this.frozenProvisions = frozenProvisions;
        this.accountCreateParams = accountCreateParams;
        this.accountRenameParams = accountRenameParams;
        this.destinationFolderId = destinationFolderId;
        this.destinationAccountId = destinationAccountId;
        this.updatedDestinationProvisions = updatedDestinationProvisions;
        this.frozenDestinationProvisions = frozenDestinationProvisions;
        this.transferRequestId = transferRequestId;
        this.deliveryId = deliveryId;
        this.accountPutParams = accountPutParams;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public Optional<List<Provision>> getUpdatedProvisions() {
        return Optional.ofNullable(updatedProvisions);
    }

    public Optional<List<Provision>> getFrozenProvisions() {
        return Optional.ofNullable(frozenProvisions);
    }

    public Optional<AccountCreateParams> getAccountCreateParams() {
        return Optional.ofNullable(accountCreateParams);
    }

    public Optional<AccountRenameParams> getAccountRenameParams() {
        return Optional.ofNullable(accountRenameParams);
    }

    public Optional<String> getDestinationFolderId() {
        return Optional.ofNullable(destinationFolderId);
    }

    public Optional<String> getDestinationAccountId() {
        return Optional.ofNullable(destinationAccountId);
    }

    public Optional<List<Provision>> getUpdatedDestinationProvisions() {
        return Optional.ofNullable(updatedDestinationProvisions);
    }

    public Optional<List<Provision>> getFrozenDestinationProvisions() {
        return Optional.ofNullable(frozenDestinationProvisions);
    }

    public Optional<String> getTransferRequestId() {
        return Optional.ofNullable(transferRequestId);
    }

    public Optional<String> getDeliveryId() {
        return Optional.ofNullable(deliveryId);
    }

    public Optional<AccountPutParams> getAccountPutParams() {
        return Optional.ofNullable(accountPutParams);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationChangesModel that = (OperationChangesModel) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(updatedProvisions, that.updatedProvisions) &&
                Objects.equals(frozenProvisions, that.frozenProvisions) &&
                Objects.equals(accountCreateParams, that.accountCreateParams) &&
                Objects.equals(accountRenameParams, that.accountRenameParams) &&
                Objects.equals(destinationFolderId, that.destinationFolderId) &&
                Objects.equals(destinationAccountId, that.destinationAccountId) &&
                Objects.equals(updatedDestinationProvisions, that.updatedDestinationProvisions) &&
                Objects.equals(frozenDestinationProvisions, that.frozenDestinationProvisions) &&
                Objects.equals(transferRequestId, that.transferRequestId) &&
                Objects.equals(deliveryId, that.deliveryId) &&
                Objects.equals(accountPutParams, that.accountPutParams);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, updatedProvisions, frozenProvisions, accountCreateParams, accountRenameParams,
                destinationFolderId, destinationAccountId, updatedDestinationProvisions, frozenDestinationProvisions,
                transferRequestId, deliveryId, accountPutParams);
    }

    @Override
    public String toString() {
        return "OperationChangesModel{" +
                "accountId='" + accountId + '\'' +
                ", updatedProvisions=" + updatedProvisions +
                ", frozenProvisions=" + frozenProvisions +
                ", accountCreateParams=" + accountCreateParams +
                ", accountRenameParams=" + accountRenameParams +
                ", destinationFolderId='" + destinationFolderId + '\'' +
                ", destinationAccountId='" + destinationAccountId + '\'' +
                ", updatedDestinationProvisions=" + updatedDestinationProvisions +
                ", frozenDestinationProvisions=" + frozenDestinationProvisions +
                ", transferRequestId='" + transferRequestId + '\'' +
                ", deliveryId='" + deliveryId + '\'' +
                ", accountPutParams=" + accountPutParams +
                '}';
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class AccountCreateParams {

        private final String key;
        private final String displayName;
        private final String folderId;
        private final String accountId;
        private final Boolean freeTier;
        @Nullable
        private final AccountReserveType reserveType;

        @JsonCreator
        public AccountCreateParams(@JsonProperty("key") String key,
                                   @JsonProperty("displayName") String displayName,
                                   @JsonProperty("folderId") String folderId,
                                   @JsonProperty("accountId") String accountId,
                                   @JsonProperty("freeTier") Boolean freeTier,
                                   @JsonProperty("reserveType") @Nullable AccountReserveType reserveType
        ) {
            this.key = key;
            this.displayName = displayName;
            this.folderId = folderId;
            this.accountId = accountId;
            this.freeTier = freeTier;
            this.reserveType = reserveType;
        }

        public Optional<String> getKey() {
            return Optional.ofNullable(key);
        }

        public Optional<String> getDisplayName() {
            return Optional.ofNullable(displayName);
        }

        public String getFolderId() {
            return folderId;
        }

        public String getAccountId() {
            return accountId;
        }

        @JsonProperty("freeTier")
        public Optional<Boolean> getFreeTier() {
            return Optional.ofNullable(freeTier);
        }

        @JsonInclude(JsonInclude.Include.NON_EMPTY)
        public Optional<AccountReserveType> getReserveType() {
            return Optional.ofNullable(reserveType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            AccountCreateParams that = (AccountCreateParams) o;
            return Objects.equals(key, that.key) &&
                    Objects.equals(displayName, that.displayName) &&
                    Objects.equals(folderId, that.folderId) &&
                    Objects.equals(accountId, that.accountId) &&
                    Objects.equals(freeTier, that.freeTier) &&
                    Objects.equals(reserveType, that.reserveType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(key, displayName, folderId, accountId, freeTier, reserveType);
        }

        @Override
        public String toString() {
            return "AccountCreateParams{" +
                    "key='" + key + '\'' +
                    ", displayName='" + displayName + '\'' +
                    ", folderId='" + folderId + '\'' +
                    ", accountId='" + accountId + '\'' +
                    ", freeTier=" + freeTier +
                    ", reserveType=" + reserveType +
                    '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class AccountRenameParams {

        private final String displayName;

        @JsonCreator
        public AccountRenameParams(@JsonProperty("displayName") String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return displayName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            AccountRenameParams that = (AccountRenameParams) o;
            return Objects.equals(displayName, that.displayName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(displayName);
        }

        @Override
        public String toString() {
            return "AccountRenameParams{" +
                    "displayName='" + displayName + '\'' +
                    '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class AccountPutParams {

        private final AccountReserveType reserveType;

        @JsonCreator
        public AccountPutParams(@JsonProperty("reserveType") AccountReserveType reserveType) {
            this.reserveType = reserveType;
        }

        public Optional<AccountReserveType> getReserveType() {
            return Optional.ofNullable(reserveType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            AccountPutParams that = (AccountPutParams) o;
            return reserveType == that.reserveType;
        }

        @Override
        public int hashCode() {
            return Objects.hash(reserveType);
        }

        @Override
        public String toString() {
            return "AccountPutParams{" +
                    "reserveType=" + reserveType +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Provision {

        private final String resourceId;
        private final long amount;

        @JsonCreator
        public Provision(@JsonProperty("resourceId") String resourceId, @JsonProperty("amount") long amount) {
            this.resourceId = resourceId;
            this.amount = amount;
        }

        public String getResourceId() {
            return resourceId;
        }

        public long getAmount() {
            return amount;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Provision provision = (Provision) o;
            return amount == provision.amount &&
                    Objects.equals(resourceId, provision.resourceId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(resourceId, amount);
        }

        @Override
        public String toString() {
            return "Provision{" +
                    "resourceId='" + resourceId + '\'' +
                    ", amount=" + amount +
                    '}';
        }

    }

    public static final class Builder {

        private String accountId;
        private List<Provision> updatedProvisions;
        private List<Provision> frozenProvisions;
        private AccountCreateParams accountCreateParams;
        private AccountRenameParams accountRenameParams;
        private String destinationFolderId;
        private String destinationAccountId;
        private List<Provision> updatedDestinationProvisions;
        private List<Provision> frozenDestinationProvisions;
        private String transferRequestId;
        private String deliveryId;
        private AccountPutParams accountPutParams;

        private Builder() {
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder updatedProvisions(List<Provision> updatedProvisions) {
            this.updatedProvisions = updatedProvisions;
            return this;
        }

        public Builder frozenProvisions(List<Provision> frozenProvisions) {
            this.frozenProvisions = frozenProvisions;
            return this;
        }

        public Builder accountCreateParams(AccountCreateParams accountCreateParams) {
            this.accountCreateParams = accountCreateParams;
            return this;
        }

        public Builder accountRenameParams(AccountRenameParams accountRenameParams) {
            this.accountRenameParams = accountRenameParams;
            return this;
        }

        public Builder destinationFolderId(String destinationFolderId) {
            this.destinationFolderId = destinationFolderId;
            return this;
        }

        public Builder destinationAccountId(String destinationAccountId) {
            this.destinationAccountId = destinationAccountId;
            return this;
        }

        public Builder updatedDestinationProvisions(List<Provision> updatedDestinationProvisions) {
            this.updatedDestinationProvisions = updatedDestinationProvisions;
            return this;
        }

        public Builder frozenDestinationProvisions(List<Provision> frozenDestinationProvisions) {
            this.frozenDestinationProvisions = frozenDestinationProvisions;
            return this;
        }

        public Builder transferRequestId(String transferRequestId) {
            this.transferRequestId = transferRequestId;
            return this;
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder accountPutParams(AccountPutParams accountPutParams) {
            this.accountPutParams = accountPutParams;
            return this;
        }

        public OperationChangesModel build() {
            return new OperationChangesModel(accountId, updatedProvisions, frozenProvisions, accountCreateParams,
                    accountRenameParams, destinationFolderId, destinationAccountId, updatedDestinationProvisions,
                    frozenDestinationProvisions, transferRequestId, deliveryId, accountPutParams);
        }

    }

}
