package ru.yandex.intranet.d.model.accounts;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.util.result.ErrorCollection;
import ru.yandex.intranet.d.util.result.TypedError;

/**
 * Error collection for operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class OperationErrorCollection {

    private final Set<TypedError> errors;
    private final Map<String, Set<TypedError>> fieldErrors;
    private final Map<String, Set<Object>> details;

    @JsonCreator
    public OperationErrorCollection(Set<TypedError> errors, Map<String, Set<TypedError>> fieldErrors,
                                    Map<String, Set<Object>> details) {
        this.errors = errors;
        this.fieldErrors = fieldErrors;
        this.details = details;
    }

    public OperationErrorCollection(ErrorCollection errorCollection) {
        this.errors = errorCollection.getErrors();
        this.fieldErrors = errorCollection.getFieldErrors();
        this.details = errorCollection.getDetails();
    }

    public ErrorCollection toErrorCollection() {
        ErrorCollection.Builder builder = ErrorCollection.builder();

        if (errors != null) {
            errors.forEach(builder::addError);
        }
        if (fieldErrors != null) {
            fieldErrors.forEach((k, set) -> set.forEach(e -> builder.addError(k, e)));
        }
        if (details != null) {
            details.forEach((k, set) -> set.forEach(o -> builder.addDetail(k, o)));
        }

        return builder.build();
    }

    public Set<TypedError> getErrors() {
        return errors;
    }

    public Map<String, Set<TypedError>> getFieldErrors() {
        return fieldErrors;
    }

    public Map<String, Set<Object>> getDetails() {
        return details;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationErrorCollection that = (OperationErrorCollection) o;
        return Objects.equals(errors, that.errors) &&
                Objects.equals(fieldErrors, that.fieldErrors) &&
                Objects.equals(details, that.details);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errors, fieldErrors, details);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
