package ru.yandex.intranet.d.model.accounts

import ru.yandex.intranet.d.kotlin.AccountId
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.model.TenantId

/**
 * Provider reserve account.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ProviderReserveAccountModel(
    val key: ProviderReserveAccountKey
)

/**
 * Provider reserve account key.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ProviderReserveAccountKey(
    val tenantId: TenantId,
    val providerId: ProviderId,
    val accountsSpaceId: AccountsSpacesId?,
    val accountId: AccountId
)
