package ru.yandex.intranet.d.model.aggregates

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.math.BigInteger

/**
 * Aggregate bundle.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class AggregateBundle(
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val quota: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val balance: BigInteger, // quota - provided
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val provided: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val allocated: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val usage: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val unallocated: BigInteger, // provided - allocated
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val unused: BigInteger, // allocated - usage
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val underutilized: BigInteger, // provided - usage
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val transferable: BigInteger, // (balance OR 0) + (unallocated OR underutilized OR 0)
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val deallocatable: BigInteger, // (unused OR 0)
    val extUsage: Boolean?, // Is non-empty usage present in separate table? Null means false.
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val unusedEst: BigInteger?, // Estimation of unused
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val underutilizedEst: BigInteger? // Estimation of underutilized
)
