package ru.yandex.intranet.d.model.aggregates

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

/**
 * Service aggregate amounts.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class ServiceAggregateAmounts(
    // Non-null when at least one field is non-zero
    val own: AggregateBundle?,
    // Non-null when at least one field is non-zero
    val subtree: AggregateBundle?,
    // Non-null when at least one field is non-zero and subtree is non-null
    val total: AggregateBundle?
)
