package ru.yandex.intranet.d.model.delivery;

import java.time.Instant;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;

/**
 * Deliverable folder operation DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableFolderOperationModel {

    private final String folderId;
    private final Instant operationDateTime;
    private final String id;
    private final Long timestamp;

    @JsonCreator
    public DeliverableFolderOperationModel(String folderId, Instant operationDateTime, String id, Long timestamp) {
        this.folderId = folderId;
        this.operationDateTime = operationDateTime;
        this.id = id;
        this.timestamp = timestamp;

    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFolderId() {
        return folderId;
    }

    public Instant getOperationDateTime() {
        return operationDateTime;
    }

    public String getId() {
        return id;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableFolderOperationModel that = (DeliverableFolderOperationModel) o;
        return Objects.equals(timestamp, that.timestamp) && Objects.equals(folderId, that.folderId)
                && Objects.equals(operationDateTime, that.operationDateTime) && Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderId, operationDateTime, id, timestamp);
    }

    @Override
    public String toString() {
        return "DeliverableFolderOperationModel{" +
                "folderId='" + folderId + '\'' +
                ", operationDateTime=" + operationDateTime +
                ", id='" + id + '\'' +
                ", timestamp=" + timestamp +
                '}';
    }

    public static final class Builder {

        private String folderId;
        private Instant operationDateTime;
        private String id;
        private Long timestamp;

        private Builder() {
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder operationDateTime(Instant operationDateTime) {
            this.operationDateTime = operationDateTime;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DeliverableFolderOperationModel build() {
            Preconditions.checkNotNull(folderId, "FolderId is required");
            Preconditions.checkNotNull(operationDateTime, "OperationDateTime is required");
            Preconditions.checkNotNull(id, "Id is required");

            return new DeliverableFolderOperationModel(folderId, operationDateTime, id, timestamp);
        }

    }

}
