package ru.yandex.intranet.d.model.delivery;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;

/**
 * Deliverable metadata response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableMetaResponseModel {

    private final long quotaRequestId;
    private final long campaignId;
    private final long bigOrderId;

    @JsonCreator
    public DeliverableMetaResponseModel(long quotaRequestId, long campaignId, long bigOrderId) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableMetaResponseModel that = (DeliverableMetaResponseModel) o;
        return quotaRequestId == that.quotaRequestId &&
                campaignId == that.campaignId &&
                bigOrderId == that.bigOrderId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderId);
    }

    @Override
    public String toString() {
        return "DeliverableMetaResponseModel{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                '}';
    }

    public static final class Builder {

        private Long quotaRequestId;
        private Long campaignId;
        private Long bigOrderId;

        private Builder() {
        }

        public Builder quotaRequestId(long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder campaignId(long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder bigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public DeliverableMetaResponseModel build() {
            Preconditions.checkNotNull(quotaRequestId, "QuotaRequestId is required");
            Preconditions.checkNotNull(campaignId, "CampaignId is required");
            Preconditions.checkNotNull(bigOrderId, "BigOrderId is required");
            return new DeliverableMetaResponseModel(quotaRequestId, campaignId, bigOrderId);
        }

    }

}
