package ru.yandex.intranet.d.model.delivery;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Delivery response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliveryResponseModel {

    private final Set<DeliverableResponseModel> deliverables;

    @JsonCreator
    public DeliveryResponseModel(Set<DeliverableResponseModel> deliverables) {
        this.deliverables = deliverables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<DeliverableResponseModel> getDeliverables() {
        return deliverables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryResponseModel that = (DeliveryResponseModel) o;
        return Objects.equals(deliverables, that.deliverables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliverables);
    }

    @Override
    public String toString() {
        return "DeliveryResponseModel{" +
                "deliverables=" + deliverables +
                '}';
    }

    public static final class Builder {

        private final Set<DeliverableResponseModel> deliverables = new HashSet<>();

        private Builder() {
        }

        public Builder addDeliverable(DeliverableResponseModel deliverable) {
            this.deliverables.add(deliverable);
            return this;
        }

        public DeliveryResponseModel build() {
            return new DeliveryResponseModel(deliverables);
        }

    }

}
