package ru.yandex.intranet.d.model.delivery;

import java.util.List;
import java.util.Objects;

import com.google.common.base.Preconditions;

import ru.yandex.intranet.d.model.TenantId;

/**
 * Finished delivery.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class FinishedDeliveryModel {

    private final String id;
    private final TenantId tenantId;
    private final DeliveryRequestModel request;
    private final DeliveryResponseModel response;
    private final List<String> operationIds;

    public FinishedDeliveryModel(String id, TenantId tenantId, DeliveryRequestModel request,
                                 DeliveryResponseModel response, List<String> operationIds) {
        this.id = id;
        this.tenantId = tenantId;
        this.request = request;
        this.response = response;
        this.operationIds = operationIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return id;
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public DeliveryRequestModel getRequest() {
        return request;
    }

    public DeliveryResponseModel getResponse() {
        return response;
    }

    public List<String> getOperationIds() {
        return operationIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FinishedDeliveryModel that = (FinishedDeliveryModel) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(tenantId, that.tenantId) &&
                Objects.equals(request, that.request) &&
                Objects.equals(response, that.response) &&
                Objects.equals(operationIds, that.operationIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tenantId, request, response, operationIds);
    }

    @Override
    public String toString() {
        return "FinishedDeliveryModel{" +
                "id='" + id + '\'' +
                ", tenantId=" + tenantId +
                ", request=" + request +
                ", response=" + response +
                ", operationIds=" + operationIds +
                '}';
    }

    public static final class Builder {

        private String id;
        private TenantId tenantId;
        private DeliveryRequestModel request;
        private DeliveryResponseModel response;
        private List<String> operationIds = List.of();

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder request(DeliveryRequestModel request) {
            this.request = request;
            return this;
        }

        public Builder response(DeliveryResponseModel response) {
            this.response = response;
            return this;
        }

        public Builder operationIds(List<String> operationIds) {
            this.operationIds = operationIds;
            return this;
        }

        public FinishedDeliveryModel build() {
            Preconditions.checkNotNull(id, "Id is required");
            Preconditions.checkNotNull(tenantId, "TenantId is required");
            Preconditions.checkNotNull(request, "Request is required");
            Preconditions.checkNotNull(response, "Response is required");
            return new FinishedDeliveryModel(id, tenantId, request, response, operationIds);
        }

    }

}
