package ru.yandex.intranet.d.model.delivery.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.intranet.d.model.delivery.DeliverableDeltaModel
import ru.yandex.intranet.d.model.delivery.DeliverableFolderOperationModel
import ru.yandex.intranet.d.model.delivery.DeliverableMetaRequestModel

/**
 * Destination for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideDestinationModel @JsonCreator constructor(
    val serviceId: Long,
    val providerId: String,
    val folderId: String,
    val accountId: String,
    val resourceId: String,
    val delta: DeliverableDeltaModel,
    val meta: DeliverableMetaRequestModel,
    val folderOperationModel: DeliverableFolderOperationModel?
) {
    data class Builder(var serviceId: Long? = null,
                       var providerId: String? = null,
                       var folderId: String? = null,
                       var accountId: String? = null,
                       var resourceId: String? = null,
                       var delta: DeliverableDeltaModel? = null,
                       var meta: DeliverableMetaRequestModel? = null,
                       var folderOperationModel: DeliverableFolderOperationModel? = null
    ) {
        fun serviceId(serviceId: Long) = apply { this.serviceId = serviceId }
        fun providerId(providerId: String) = apply { this.providerId = providerId }
        fun folderId(folderId: String) = apply { this.folderId = folderId }
        fun accountId(accountId: String) = apply { this.accountId = accountId }
        fun resourceId(resourceId: String) = apply { this.resourceId = resourceId }
        fun delta(delta: DeliverableDeltaModel) = apply { this.delta = delta }
        fun meta(meta: DeliverableMetaRequestModel) = apply { this.meta = meta }
        fun folderOperationModel(folderOperationModel: DeliverableFolderOperationModel) = apply {
            this.folderOperationModel = folderOperationModel
        }
        fun build() = DeliveryAndProvideDestinationModel(serviceId!!, providerId!!, folderId!!, accountId!!,
            resourceId!!, delta!!, meta!!, folderOperationModel)
    }
}
