package ru.yandex.intranet.d.model.delivery.provide

import ru.yandex.intranet.d.model.TenantId

/**
 * Delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
data class DeliveryAndProvideModel(
    val deliveryId: String,
    val tenantId: TenantId,
    val request: DeliveryAndProvideRequestModel,
    val operations: List<DeliveryAndProvideOperationListModel>
) {
    data class Builder(var deliveryId: String? = null,
                       var tenantId: TenantId? = null,
                       var request: DeliveryAndProvideRequestModel? = null,
                       val operations: MutableList<DeliveryAndProvideOperationListModel> = mutableListOf()
    ) {
        fun deliveryId(deliveryId: String) = apply { this.deliveryId = deliveryId }
        fun tenantId(tenantId: TenantId) = apply { this.tenantId = tenantId }
        fun request(request: DeliveryAndProvideRequestModel) = apply { this.request = request }
        fun addOperation(operation: DeliveryAndProvideOperationListModel) =
            apply { this.operations.add(operation) }
        fun addOperations(operations: Collection<DeliveryAndProvideOperationListModel>) =
            apply { this.operations.addAll(operations) }
        fun build() = DeliveryAndProvideModel(deliveryId!!, tenantId!!, request!!, operations.toList())
    }
}
