package ru.yandex.intranet.d.model.delivery.provide

/**
 * Delivery and provide operation list model
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
data class DeliveryAndProvideOperationListModel(
    val serviceId: Long,
    val folderId: String,
    val accountId: String,
    val operations: List<DeliveryAndProvideOperationModel>
) {
    data class Builder(var serviceId: Long? = null,
                       var folderId: String? = null,
                       var accountId: String? = null,
                       val operations: MutableList<DeliveryAndProvideOperationModel> = mutableListOf()
    ) {
        fun serviceId(serviceId: Long) = apply { this.serviceId = serviceId }
        fun folderId(folderId: String) = apply { this.folderId = folderId }
        fun accountId(accountId: String) = apply { this.accountId = accountId }
        fun addOperation(operation: DeliveryAndProvideOperationModel) =
            apply { this.operations.add(operation) }
        fun addOperations(operations: Collection<DeliveryAndProvideOperationModel>) =
            apply { this.operations.addAll(operations) }
        fun build() = DeliveryAndProvideOperationListModel(serviceId!!, folderId!!, accountId!!, operations.toList())
    }
}
