package ru.yandex.intranet.d.model.delivery.provide

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties

/**
 * Request for delivery and provide operation
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class DeliveryAndProvideRequestModel @JsonCreator constructor(
    val deliveryId: String,
    val authorUid: String,
    val deliverables: Set<DeliveryAndProvideDestinationModel>
) {
    data class Builder(var deliveryId: String? = null,
                       var authorUid: String? = null,
                       val deliverables: MutableSet<DeliveryAndProvideDestinationModel> = mutableSetOf()
    ) {
        fun deliveryId(deliveryId: String) = apply { this.deliveryId = deliveryId }
        fun authorUid(authorUid: String) = apply { this.authorUid = authorUid }
        fun addDeliverable(deliverable: DeliveryAndProvideDestinationModel) =
            apply { this.deliverables.add(deliverable) }
        fun addDeliverables(deliverables: Collection<DeliveryAndProvideDestinationModel>) =
            apply { this.deliverables.addAll(deliverables) }
        fun build() = DeliveryAndProvideRequestModel(deliveryId!!, authorUid!!, deliverables.toSet())
    }
}
