package ru.yandex.intranet.d.model.folders;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Accounts history model.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountsHistoryModel {

    private final Map<String, AccountHistoryModel> accounts;

    @JsonCreator
    public AccountsHistoryModel(Map<String, AccountHistoryModel> accounts) {
        this.accounts = accounts;
    }

    @JsonValue
    public Map<String, AccountHistoryModel> getAccounts() {
        return accounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsHistoryModel that = (AccountsHistoryModel) o;
        return Objects.equals(accounts, that.accounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accounts);
    }

    @Override
    public String toString() {
        return "AccountsHistoryModel{" +
                "accounts=" + accounts +
                '}';
    }

}
