package ru.yandex.intranet.d.model.folders;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Folder history fields.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class FolderHistoryFieldsModel {

    private final Long serviceId;
    private final Long version;
    private final String displayName;
    private final String description;
    private final Boolean deleted;
    private final FolderType folderType;
    private final Set<String> tags;

    @JsonCreator
    public FolderHistoryFieldsModel(@JsonProperty("serviceId") Long serviceId,
                                    @JsonProperty("version") Long version,
                                    @JsonProperty("displayName") String displayName,
                                    @JsonProperty("description") String description,
                                    @JsonProperty("deleted") Boolean deleted,
                                    @JsonProperty("folderType") FolderType folderType,
                                    @JsonProperty("tags") Set<String> tags) {
        this.serviceId = serviceId;
        this.version = version;
        this.displayName = displayName;
        this.description = description;
        this.deleted = deleted;
        this.folderType = folderType;
        this.tags = tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Long> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public Optional<FolderType> getFolderType() {
        return Optional.ofNullable(folderType);
    }

    public Optional<Set<String>> getTags() {
        return Optional.ofNullable(tags);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderHistoryFieldsModel that = (FolderHistoryFieldsModel) o;
        return Objects.equals(serviceId, that.serviceId) &&
                Objects.equals(version, that.version) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(description, that.description) &&
                Objects.equals(deleted, that.deleted) &&
                folderType == that.folderType &&
                Objects.equals(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, version, displayName, description, deleted, folderType, tags);
    }

    @Override
    public String toString() {
        return "FolderHistoryFieldsModel{" +
                "serviceId=" + serviceId +
                ", version=" + version +
                ", displayName='" + displayName + '\'' +
                ", description='" + description + '\'' +
                ", deleted=" + deleted +
                ", folderType=" + folderType +
                ", tags=" + tags +
                '}';
    }

    public static class Builder {

        private Long serviceId;
        private Long version;
        private String displayName;
        private String description;
        private Boolean deleted;
        private FolderType folderType;
        private Set<String> tags;

        private Builder() {
        }

        public Builder serviceId(long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder folderType(FolderType folderType) {
            this.folderType = folderType;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public FolderHistoryFieldsModel build() {
            return new FolderHistoryFieldsModel(serviceId, version, displayName, description, deleted,
                    folderType, tags);
        }

    }

}
