package ru.yandex.intranet.d.model.folders;

import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * FolderId.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
public final class FolderId {
    private final String value;

    public FolderId(String value) {
        this.value = value;
    }

    public static FolderId from(QuotaModel model) {
        return new FolderId(model.getFolderId());
    }

    public static FolderId from(FolderModel model) {
        return new FolderId(model.getId());
    }

    public static FolderId from(AccountModel model) {
        return new FolderId(model.getFolderId());
    }

    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderId folderId = (FolderId) o;
        return Objects.equals(value, folderId.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return "FolderId: " + value;
    }
}
