package ru.yandex.intranet.d.model.folders;

import java.time.Instant;
import java.util.Objects;

import ru.yandex.intranet.d.model.TenantId;

/**
 * FolderOperationLogCommentModel
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public final class FolderOperationLogCommentModel {
    private final TenantId tenantId;
    private final String id;
    private final Instant createdAt;
    private final String createdBy;
    private final String text;

    private FolderOperationLogCommentModel(TenantId tenantId, String id, Instant createdAt, String createdBy,
                                            String text) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.id = Objects.requireNonNull(id);
        this.createdAt = Objects.requireNonNull(createdAt);
        this.createdBy = Objects.requireNonNull(createdBy);
        this.text = Objects.requireNonNull(text);
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public String getId() {
        return id;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public String getText() {
        return text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderOperationLogCommentModel that = (FolderOperationLogCommentModel) o;
        return Objects.equals(tenantId, that.tenantId) && Objects.equals(id, that.id) && Objects.equals(createdAt,
                that.createdAt) && Objects.equals(createdBy, that.createdBy) && Objects.equals(text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, id, createdAt, createdBy, text);
    }

    @Override
    public String toString() {
        return "BulkQuotaMoveCommentModel{" +
                "tenantId=" + tenantId +
                ", id='" + id + '\'' +
                ", createdAt=" + createdAt +
                ", createdBy='" + createdBy + '\'' +
                ", text='" + text + '\'' +
                '}';
    }

    public static FolderOperationLogCommentModel.Builder builder() {
        return new FolderOperationLogCommentModel.Builder();
    }

    public static FolderOperationLogCommentModel.Builder builder(FolderOperationLogCommentModel data) {
        return new FolderOperationLogCommentModel.Builder(data);
    }

    public static final class Builder {

        private TenantId tenantId;
        private String id;
        private Instant createdAt;
        private String createdBy;
        private String text;

        private Builder() {
        }

        private Builder(FolderOperationLogCommentModel initialData) {
            this.tenantId = initialData.getTenantId();
            this.id = initialData.getId();
            this.createdAt = initialData.getCreatedAt();
            this.createdBy = initialData.getCreatedBy();
            this.text = initialData.getText();
        }

        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public FolderOperationLogCommentModel build() {
            return new FolderOperationLogCommentModel(tenantId, id, createdAt, createdBy, text);
        }
    }
}
