package ru.yandex.intranet.d.model.folders;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Provision history model.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class ProvisionHistoryModel {

    private final long provision;
    private final Long version;

    @JsonCreator
    public ProvisionHistoryModel(@JsonProperty("provision") long provision, @JsonProperty("version") Long version) {
        this.provision = provision;
        this.version = version;
    }

    public long getProvision() {
        return provision;
    }

    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionHistoryModel that = (ProvisionHistoryModel) o;
        return provision == that.provision &&
                Objects.equals(version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provision, version);
    }

    @Override
    public String toString() {
        return "ProvisionHistoryModel{" +
                "provision=" + provision +
                ", version=" + version +
                '}';
    }

}
