package ru.yandex.intranet.d.model.folders;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

/**
 * Provisions by resource.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ProvisionsByResource {

    private final Map<String, ProvisionHistoryModel> provisionsByResourceId;

    public ProvisionsByResource(Map<String, ProvisionHistoryModel> provisionsByResourceId) {
        this.provisionsByResourceId = provisionsByResourceId;
    }

    public ProvisionHistoryModel get(String resourceId) {
        return provisionsByResourceId.get(resourceId);
    }

    public void forEach(BiConsumer<? super String, ? super ProvisionHistoryModel> action) {
        provisionsByResourceId.forEach(action);
    }

    public Map<String, ProvisionHistoryModel> asMap() {
        return provisionsByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisionsByResource that = (ProvisionsByResource) o;
        return Objects.equals(provisionsByResourceId, that.provisionsByResourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provisionsByResourceId);
    }

    @Override
    public String toString() {
        return "ProvisionsByResource{" +
                "provisionsByResourceId=" + provisionsByResourceId +
                '}';
    }

}
