package ru.yandex.intranet.d.model.folders;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

/**
 * QuotasByAccount.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 23.10.2020
 */
public final class QuotasByAccount {
    private final Map<String, ProvisionsByResource> quotasByAccountId;

    public QuotasByAccount(Map<String, ProvisionsByResource> quotasByAccountId) {
        this.quotasByAccountId = Map.copyOf(quotasByAccountId);
    }

    public ProvisionsByResource get(String accountId) {
        return quotasByAccountId.get(accountId);
    }

    public void forEach(BiConsumer<? super String, ? super ProvisionsByResource> action) {
        quotasByAccountId.forEach(action);
    }

    public Map<String, ProvisionsByResource> asMap() {
        return quotasByAccountId;
    }

    public int size() {
        return quotasByAccountId.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotasByAccount that = (QuotasByAccount) o;
        return Objects.equals(quotasByAccountId, that.quotasByAccountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotasByAccountId);
    }

    @Override
    public String toString() {
        return "QuotasByAccount{" +
                quotasByAccountId +
                '}';
    }
}
