package ru.yandex.intranet.d.model.folders;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

/**
 * QuotasByResource.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 23.10.2020
 */
public final class QuotasByResource {
    private final Map<String, Long> quotasByResourceId;

    public QuotasByResource(Map<String, Long> quotasByResourceId) {
        this.quotasByResourceId = Map.copyOf(quotasByResourceId);
    }

    public Long get(String resourceId) {
        return quotasByResourceId.get(resourceId);
    }

    public void forEach(BiConsumer<? super String, ? super Long> action) {
        quotasByResourceId.forEach(action);
    }

    public Map<String, Long> asMap() {
        return quotasByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotasByResource that = (QuotasByResource) o;
        return Objects.equals(quotasByResourceId, that.quotasByResourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotasByResourceId);
    }

    @Override
    public String toString() {
        return "AssuredQuotas{" +
                quotasByResourceId +
                '}';
    }
}
