package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.UserId

/**
 * Loan action subject, i.e. subject requesting/approving/settling the loan.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
// Exactly one field must be present
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class LoanActionSubject @JsonCreator constructor(
    // The most typical case, authenticated user is present
    val user: UserId?,
    // Not an authenticated user but an authenticated provider, i.e. only provider TVM service ticket was present
    val provider: ProviderId?
)
