package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import ru.yandex.intranet.d.kotlin.ResourceId
import java.math.BigInteger

/**
 * Loan amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class LoanAmount @JsonCreator constructor(
    val resource: ResourceId,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val amount: BigInteger
)
