package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Loan event type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class LoanEventType {

    // Loan created
    LOAN_CREATED,
    // Loan parameters updated
    LOAN_UPDATED,
    // Loan is partially paid off
    LOAN_PAY_OFF,
    // Loan is paid off completely
    LOAN_SETTLED;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanEventType? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
