package ru.yandex.intranet.d.model.loans

import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.kotlin.TransferRequestId
import ru.yandex.intranet.d.model.TenantId
import java.time.Instant

/**
 * Loan.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class LoanModel(
    // Tenant id
    val tenantId: TenantId,
    // Unique loan id
    val id: LoanId,
    // Loan status
    val status: LoanStatus,
    // Loan type
    val type: LoanType,
    // Loan was created at
    val createdAt: Instant,
    // Loan is due at, local date and timezone
    val dueAt: LoanDueDate,
    // Loan was settled at
    val settledAt: Instant?,
    // Loan last updated at
    val updatedAt: Instant?,
    // Loan version, incremented on each update
    val version: Long,
    // Loan was requested by
    val requestedBy: LoanActionSubject,
    // Loan was approved by
    val requestApprovedBy: LoanActionSubjects,
    // Transfer request id of borrow
    val borrowTransferRequestId: TransferRequestId,
    // Borrow source
    val borrowedFrom: LoanSubject,
    // Borrow destination
    val borrowedTo: LoanSubject,
    // Pay off source
    val payOffFrom: LoanSubject,
    // Pay off destination
    val payOffTo: LoanSubject,
    // Borrowed amount
    val borrowedAmounts: LoanAmounts,
    // Amount to pay off
    val payOffAmounts: LoanAmounts,
    // Amount left to pay off
    val dueAmounts: LoanAmounts,
    // Approximate timestamp for due date
    val dueAtTimestamp: Instant
)
