package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Loan status.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class LoanStatus {

    // Loan pay off is still pending
    PENDING,
    // Loan has been paid off already
    SETTLED;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanStatus? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
