package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import ru.yandex.intranet.d.kotlin.AccountId
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.FolderId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ServiceId

/**
 * Loan subject, i.e. the source or the destination of the corresponding provision transfer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class LoanSubject @JsonCreator constructor(
    // Subject type, determines which fields are defined
    val type: LoanSubjectType,
    // Service is always known
    val service: ServiceId,
    // Reserve service is defined for service reserve accounts only
    // It is different from the service only if reserve account is linked to the different service
    val reserveService: ServiceId?,
    // Account may be undefined, e.g. when materializing a provision out of the thin air or destroying a provision.
    // Also, when loan mey be paid off to any account in the selected service
    val account: AccountId?,
    // Folder for the account
    val folder: FolderId?,
    // Provider is defined only for provider reserve accounts
    val provider: ProviderId?,
    // Accounts space is defined only for provider reserve accounts where provider have accounts spaces
    val accountsSpace: AccountsSpacesId?
)
