package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Loan type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class LoanSubjectType {

    // Reserve account of a provider
    PROVIDER_RESERVE_ACCOUNT,
    // Reserve of a provider, but provision is materialized out of the thin air
    PROVIDER_RESERVE_OVER_COMMIT,
    // Reserve account of a service
    SERVICE_RESERVE_ACCOUNT,
    // Just any non-special account
    ACCOUNT,
    // Any account in the service
    SERVICE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanSubjectType? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
