package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Loan type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class LoanType {
    // A loan is from a provider's reserve, the real reserved provision is transferred
    PROVIDER_RESERVE,
    // A loan is from a provider's reserve, but the provision is materialized out of the thin air on borrow and destroyed on pay off
    PROVIDER_RESERVE_OVER_COMMIT,
    // A loan is from a service reserve, think VS reserve and the likes, the real reserved provision is transferred
    SERVICE_RESERVE,
    // A loan is peer to peer, the real reserved provision is transferred
    PEER_TO_PEER;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanType? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
