package ru.yandex.intranet.d.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

/**
 * Loans history fields.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class LoansHistoryFields @JsonCreator constructor(
    // Loan version, incremented on each update
    val version: Long,
    // Loan status
    val status: LoanStatus?,
    // Loan is due at, local date and timezone
    val dueAt: LoanDueDate?,
    // Pay off source
    val payOffFrom: LoanSubject?,
    // Pay off destination
    val payOffTo: LoanSubject?,
    // Borrowed amount
    val borrowedAmounts: LoanAmounts?,
    // Amount to pay off
    val payOffAmounts: LoanAmounts?,
    // Amount left to pay off
    val dueAmounts: LoanAmounts?
)
