package ru.yandex.intranet.d.model.loans

import ru.yandex.intranet.d.kotlin.LoanHistoryId
import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.kotlin.TransferRequestId
import ru.yandex.intranet.d.model.TenantId
import java.time.Instant

/**
 * Loans history.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class LoansHistoryModel(
    // Key
    val key: LoansHistoryKey,
    // Event author
    val eventAuthor: LoanActionSubject,
    // Event approved by
    val eventApprovedBy: LoanActionSubjects?,
    // Event type
    val eventType: LoanEventType,
    // Matching transfer request id
    val transferRequestId: TransferRequestId?,
    // Old field values
    val oldFields: LoansHistoryFields?,
    // New field values
    val newFields: LoansHistoryFields?
)

data class LoansHistoryKey(
    // Tenant id
    val tenantId: TenantId,
    // Event unique id
    val id: LoanHistoryId,
    // Loan id
    val loanId: LoanId,
    // Event timestamp
    val eventTimestamp: Instant
)
