package ru.yandex.intranet.d.model.loans

import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.model.TenantId
import java.time.Instant

/**
 * Pending loan index.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class PendingLoanModel(
    // Key
    val key: PendingLoanKey,
    // Exact due date
    val dueAt: LoanDueDate,
    // Notifications metadata
    val notifications: LoanNotifications?
)

data class PendingLoanKey(
    // Tenant id
    val tenantId: TenantId,
    // Approximate timestamp for due date
    val dueAtTimestamp: Instant,
    // Loan id
    val loanId: LoanId
)
