package ru.yandex.intranet.d.model.loans

import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.model.TenantId
import java.math.BigInteger

/**
 * Service loan resource balance.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ServiceLoanBalanceModel(
    // Key
    val key: ServiceLoanBalanceKey,
    // Amount this service will receive when all loans are settled
    val amountIn: BigInteger,
    // Amount this service will give out when all loans are settled
    val amountOut: BigInteger
)

data class ServiceLoanBalanceKey(
    // Tenant id
    val tenantId: TenantId,
    // ABC service id
    val serviceId: ServiceId,
    // Provider id
    val providerId: ProviderId,
    // Resource id
    val resourceId: ResourceId
)
