package ru.yandex.intranet.d.model.loans

import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.model.TenantId
import java.time.Instant

/**
 * Service loan outgoing index. Service will send payments on these loans.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class ServiceLoanOutModel(
    // Tenant id
    val tenantId: TenantId,
    // ABC service id
    val serviceId: ServiceId,
    // Loan status
    val status: LoanStatus,
    // Loan is due at, approximation of due date as UTC timestamp
    val dueAt: Instant,
    // Loan id
    val loanId: LoanId
)
