package ru.yandex.intranet.d.model.providers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

/**
 * Aggregation settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class AggregationAlgorithm(
    val disabled: Boolean?,
    val upsertPageSize: Long?,
    val quotaQueryType: AggregationQuotaQueryType?,
    val concurrentAggregatesUpsert: Boolean?,
    val concurrentAggregation: Boolean?,
    val resourcesPageSize: Long?,
    val paginateResources: Boolean?,
    val concurrentCleanup: Boolean?
)
