package ru.yandex.intranet.d.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Potentially free provision amounts aggregation mode.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class AggregationQuotaQueryType {
    SCAN_SNAPSHOT,
    PAGINATE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): AggregationQuotaQueryType? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }
}
