package ru.yandex.intranet.d.model.providers;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Billing metadata for provider.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class BillingMeta {

    private final String meteringKey;

    @JsonCreator
    public BillingMeta(@JsonProperty("meteringKey") String meteringKey) {
        this.meteringKey = meteringKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BillingMeta value) {
        return new Builder(value);
    }

    public Optional<String> getMeteringKey() {
        return Optional.ofNullable(meteringKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BillingMeta that = (BillingMeta) o;
        return Objects.equals(meteringKey, that.meteringKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(meteringKey);
    }

    @Override
    public String toString() {
        return "BillingMeta{" +
                "meteringKey='" + meteringKey + '\'' +
                '}';
    }

    public static final class Builder {

        private String meteringKey;

        private Builder() {
        }

        private Builder(BillingMeta value) {
            this.meteringKey = value.meteringKey;
        }

        public Builder meteringKey(String meteringKey) {
            this.meteringKey = meteringKey;
            return this;
        }

        public BillingMeta build() {
            return new BillingMeta(meteringKey);
        }

    }

}
