package ru.yandex.intranet.d.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Potentially free provision amounts aggregation mode.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class FreeProvisionAggregationMode {
    NONE,
    UNALLOCATED_TRANSFERABLE,
    UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE,
    UNDERUTILIZED_TRANSFERABLE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): FreeProvisionAggregationMode? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }
}
