package ru.yandex.intranet.d.model.providers;

import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * ProviderId.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
public final class ProviderId {
    private final String value;

    public ProviderId(String value) {
        this.value = value;
    }

    public static ProviderId from(QuotaModel model) {
        return new ProviderId(model.getProviderId());
    }

    public static ProviderId from(AccountModel model) {
        return new ProviderId(model.getProviderId());
    }

    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderId that = (ProviderId) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return "ProviderId: " + value;
    }
}
