package ru.yandex.intranet.d.model.providers

import ru.yandex.intranet.d.model.GrammaticalCases
import ru.yandex.intranet.d.model.MultilingualGrammaticalForms

/**
 * ProviderUISettings.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 02-03-2022
 */
data class ProviderUISettings(
    val titleForTheAccount: MultilingualGrammaticalForms?,
) {
    companion object {
        @Suppress("GrazieInspection")
        @JvmStatic
        fun defaultValue() = ProviderUISettings(
            titleForTheAccount = MultilingualGrammaticalForms(
                nameSingularRu = GrammaticalCases(
                    nominative =    "аккаунт",      // кто, что?      именительный
                    genitive =      "аккаунта",     // кого, чего?    родительный
                    dative =        "аккаунту",     // кому, чему?    дательный
                    accusative =    "аккаунт",      // кого, что?     винительный
                    instrumental =  "аккаунтом",    // кем, чем?      творительный
                    prepositional = "об аккаунте",  // о ком, о чём?  предложный
                    locative =      "в аккаунте",   // где?           местный
                ),
                namePluralRu = GrammaticalCases(
                    nominative =    "аккаунты",     // кто, что?      именительный
                    genitive =      "аккаунтов",    // кого, чего?    родительный
                    dative =        "аккаунтам",    // кому, чему?    дательный
                    accusative =    "аккаунты",     // кого, что?     винительный
                    instrumental =  "аккаунтами",   // кем, чем?      творительный
                    prepositional = "об аккаунтах", // о ком, о чём?  предложный
                    locative =      "в аккаунтах",  // где?           местный
                ),
                nameSingularEn = "account",
                namePluralEn = "accounts",
            )
        )
    }
}
