package ru.yandex.intranet.d.model.providers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Related resource coefficient.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedCoefficient {
    private final long numerator;
    private final long denominator;

    @JsonCreator
    public RelatedCoefficient(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public long getNumerator() {
        return numerator;
    }

    public long getDenominator() {
        return denominator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedCoefficient that = (RelatedCoefficient) o;
        return numerator == that.numerator &&
                denominator == that.denominator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(numerator, denominator);
    }

    @Override
    public String toString() {
        return "RelatedCoefficient{" +
                "numerator=" + numerator +
                ", denominator=" + denominator +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long numerator;
        private Long denominator;

        public Builder numerator(Long numerator) {
            this.numerator = numerator;
            return this;
        }

        public Builder denominator(Long denominator) {
            this.denominator = denominator;
            return this;
        }

        public RelatedCoefficient build() {
            Objects.requireNonNull(numerator);
            Objects.requireNonNull(denominator);
            return new RelatedCoefficient(numerator, denominator);
        }
    }
}
